package ytlogs

import (
	"encoding/json"
	"strconv"
)

type (
	AviaWizardQueryRecord struct {
		YandexUID       string  `json:"yandexuid"`
		PassportID      string  `json:"passport_id"`
		Unixtime        uint32  `json:"unixtime"`
		FromID          string  `json:"from_id"`
		ToID            string  `json:"to_id"`
		When            string  `json:"departure_date"`
		ReturnDate      string  `json:"return_date"`
		NationalVersion string  `json:"tld"`
		Lang            string  `json:"lang"`
		AviaDynamic     bool    `json:"avia_dynamic"`
		Organic         bool    `json:"organic"`
		MainReqID       string  `json:"main_reqid"`
		PassengersInfo  string  `json:"passengers_info"`
		RawArgs         RawArgs `json:"raw_args"`
	}
	RawArgs struct {
		AviaDynamic []AviaDynamic `json:"avia_dynamic"`
	}

	AviaDynamic struct {
		FirstRequest int `json:"first_request"`
	}

	RawAviaDynamic struct {
		FirstRequest int `json:"first_request"`
	}
)

func (a *AviaDynamic) UnmarshalJSON(rawBytes []byte) error {
	rawString, err := strconv.Unquote(string(rawBytes))
	if err != nil {
		return err
	}
	raw := RawAviaDynamic{}
	err = json.Unmarshal([]byte(rawString), &raw)
	if err != nil {
		return err
	}
	a.FirstRequest = raw.FirstRequest
	return err
}
