# -*- coding: utf-8 -*-
import logging
import sys
from argparse import ArgumentParser

from travel.avia.library.python.lib_yt.client import configured_client

from travel.avia.price_index.bin.dump_to_yt.dumper import Dumper
from travel.avia.price_index.lib.settings import settings

logger = logging.getLogger(__name__)

if __name__ == '__main__':
    logging.basicConfig(
        level=logging.INFO,
        stream=sys.stdout,
    )

    parser = ArgumentParser()

    parser.add_argument('--national-version', required=True, type=str)
    parser.add_argument('--days', default=30, type=int)
    parser.add_argument('--max-transfers', default=2, type=int)
    parser.add_argument('--search-url-template', required=True, type=str)
    parser.add_argument('--route-url-template', required=True, type=str)
    parser.add_argument('--landing-routes-table', required=True, type=str)
    parser.add_argument('--yt-table', required=True, type=str)

    arguments = parser.parse_args()

    dumper = Dumper(
        national_version=arguments.national_version,
        search_url_template=arguments.search_url_template,
        route_url_template=arguments.route_url_template,
        yt_client=configured_client('hahn', settings.YT_TOKEN),
        landing_routes_table=arguments.landing_routes_table,
        logger=logger,
    )
    dumper.dump(
        days=arguments.days,
        max_transfers=arguments.max_transfers,
        yt_table=arguments.yt_table,
    )
