import asyncio
import logging
import os

from aiohttp import web

from travel.avia.price_index.bin.indexer.health_check_server import settings

logger = logging.getLogger(__name__)

VERSION = os.getenv('DEPLOY_DOCKER_IMAGE', ':unknown').rsplit(':', 1)[-1]


async def version(request):
    return web.Response(status=200, text=f'Package tag: {VERSION}\n')


async def ping(request):
    ok = await check_indexer_status()
    if ok:
        return web.Response(text='ok', status=200)
    else:
        return web.Response(text='error', status=500)


async def check_indexer_status():
    cmd = 'supervisorctl status'
    proc = await asyncio.create_subprocess_shell(
        cmd,
        stdout=asyncio.subprocess.PIPE,
        stderr=asyncio.subprocess.PIPE,
    )
    stdout, stderr = await proc.communicate()

    if not proc.returncode and not stderr and stdout:
        indexer_lines = [line.strip() for line in stdout.decode().split('\n') if 'indexer' in line]
        if indexer_lines and all('RUNNING' in l for l in indexer_lines):
            return True

    logger.error(f'"{cmd}" return code "{proc.returncode}", stderr "{stderr.decode()}", stdout "{stdout.decode()}"')
    return False


def main():
    settings.setup_logging()

    routes = [
        web.get('/ping', ping),
        web.get('/version', version),
    ]

    app = web.Application()
    app.add_routes(routes)
    web.run_app(app, port=settings.SERVER_PORT)
