import os
import sys
import logging.config

SERVER_PORT = int(os.getenv('AVIA_INDEXER_HEALTH_CHECK_SERVER_PORT', 8080))
SERVER_LOG_LEVEL = os.getenv('AVIA_INDEXER_HEALTH_CHECK_SERVER_LOG_LEVEL', logging.INFO)
SERVER_LOG_PATH = os.getenv('AVIA_INDEXER_HEALTH_CHECK_SERVER_LOG_PATH',
                            '/var/log/yandex-avia-price-index/indexer-health-check-server/')


def setup_logging():
    logging_conf = {
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'handlers': ['tree', 'error', 'traceback'],
            'level': SERVER_LOG_LEVEL,
        },
        'formatters': {
            'verbose': {
                'format': '%(levelname)s %(asctime)s: (%(name)s) %(message)s',
                'datefmt': '%Y-%m-%d %H:%M:%S',
            },
            'tree': {
                'format': '%(levelname)s %(asctime)s: %(message)s',
                'datefmt': '%Y-%m-%d %H:%M:%S',
            },
            'error': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(asctime)s %(name)-15s %(levelname)-10s %(message)s',
            },
            'traceback': {
                '()': 'ylog.ExceptionFormatter',
                'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
                'full': True,
                'show_locals': True,
            },
            'json': {
                '()': 'cloud_logger.formatters.DeployJsonFormatter',
                'format': '%(name)s: %(message)s',
                'datefmt': '%Y-%m-%d %H:%M:%S',
            },
        },
        'handlers': {
            'tree': {
                'level': SERVER_LOG_LEVEL,
                'class': 'cloud_logger.handlers.ArcadiaFileTreeHandler',
                'base_path': SERVER_LOG_PATH,
                'formatter': 'tree',
                'remove_prefix': '',
            },
            'error': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(SERVER_LOG_PATH, 'error.log'),
                'formatter': 'error',
                'level': 'ERROR',
            },
            'traceback': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(SERVER_LOG_PATH, 'traceback.log'),
                'formatter': 'traceback',
                'level': 'ERROR',
            },
            'deploy': {
                'level': SERVER_LOG_LEVEL,
                'class': 'logging.StreamHandler',
                'stream': sys.stdout,
                'formatter': 'json',
            },
            'console': {
                'level': SERVER_LOG_LEVEL,
                'class': 'logging.StreamHandler',
                'stream': sys.stdout,
                'formatter': 'verbose',
            },
        },
    }
    if os.getenv('DEPLOY_STAGE_ID') is not None:
        logging_conf['root']['handlers'].append('deploy')
    else:
        logging_conf['root']['handlers'].append('console')
    logging.config.dictConfig(logging_conf)
