from __future__ import with_statement


def main():
    import os
    import sys

    current_dir = os.path.abspath(os.path.join(os.getcwd(), "."))
    sys.path.insert(0, current_dir)

    from alembic import context
    from sqlalchemy import engine_from_config, pool
    from logging.config import fileConfig

    from travel.avia.price_index.db_models.base_model import DbModel
    from travel.avia.price_index.lib.settings import settings

    config = context.config
    config.set_main_option('sqlalchemy.url', settings.MASTER_CONNECTION_STRING_FOR_MIGRATION)

    fileConfig(config.config_file_name)

    target_metadata = DbModel.metadata

    # noinspection PyUnusedLocal
    def include_object(_object, name, type_, reflected, compare_to):
        if type_ == "table" and name.startswith('z_'):
            return False
        return True

    def run_migrations_offline():
        """Run migrations in 'offline' mode.

        This configures the context with just a URL
        and not an Engine, though an Engine is acceptable
        here as well.  By skipping the Engine creation
        we don't even need a DBAPI to be available.

        Calls to context.execute() here emit the given string to the
        script output.

        """
        url = config.get_main_option("sqlalchemy.url")
        context.configure(url=url, target_metadata=target_metadata, literal_binds=True)

        with context.begin_transaction():
            context.run_migrations()

    def run_migrations_online():
        """Run migrations in 'online' mode.

        In this scenario we need to create an Engine
        and associate a connection with the context.

        """
        connectable = engine_from_config(
            config.get_section(config.config_ini_section), prefix='sqlalchemy.', poolclass=pool.NullPool
        )

        with connectable.connect() as connection:
            context.configure(connection=connection, target_metadata=target_metadata, include_object=include_object)

            with context.begin_transaction():
                context.run_migrations()

    if context.is_offline_mode():
        run_migrations_offline()
    else:
        run_migrations_online()


main()
