"""query

Revision ID: 3a87cb3bd917
Revises:
Create Date: 2017-09-27 11:03:02.713180+00:00

"""
from alembic import op


# revision identifiers, used by Alembic.
from sqlalchemy import Column, Integer, Sequence, SmallInteger, Date, Boolean, DateTime
from sqlalchemy.sql.ddl import CreateSequence, DropSequence

revision = '3a87cb3bd917'
down_revision = None
branch_labels = None
depends_on = None

QUERY_ID_SEQ = Sequence('query_id_seq')


def upgrade():
    op.execute(CreateSequence(QUERY_ID_SEQ))
    op.create_table(
        'query',
        Column('pk', Integer, QUERY_ID_SEQ, primary_key=True, server_default=QUERY_ID_SEQ.next_value()),
        Column('national_version_id', SmallInteger, nullable=False),
        Column('from_id', Integer, nullable=False),
        Column('to_id', Integer, nullable=False),
        Column('forward_date', Date, nullable=False),
        Column('backward_date', Date, nullable=False),
        Column('adults_count', SmallInteger, nullable=False),
        Column('children_count', SmallInteger, nullable=False),
        Column('infants_count', SmallInteger, nullable=False),
        Column('is_business', Boolean, nullable=False),
        Column('last_update', DateTime, nullable=False),
    )
    op.create_unique_constraint(
        'query_uniq_constraint',
        'query',
        [
            'national_version_id',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            'adults_count',
            'children_count',
            'infants_count',
            'is_business',
        ],
    )


def downgrade():
    op.drop_table('query')
    op.execute(DropSequence(QUERY_ID_SEQ))
