"""flight

Revision ID: 4b1fcbcf469c
Revises: 3a87cb3bd917
Create Date: 2017-09-27 13:08:36.493749+00:00

"""
from alembic import op
from sqlalchemy import Sequence, BigInteger, Column, DateTime, Integer, Text
from sqlalchemy.sql.ddl import CreateSequence, DropSequence

revision = '4b1fcbcf469c'
down_revision = '3a87cb3bd917'
branch_labels = None
depends_on = None

FLIGHT_ID_SEQ = Sequence('flight_id_seq')  # define sequence explicitly


def upgrade():
    op.execute(CreateSequence(FLIGHT_ID_SEQ))
    op.create_table(
        'flight',
        Column('pk', BigInteger, FLIGHT_ID_SEQ, primary_key=True, server_default=FLIGHT_ID_SEQ.next_value()),
        Column('departure', DateTime, nullable=False),
        Column('arrival', DateTime, nullable=False),
        Column('departure_utc', DateTime, nullable=False),
        Column('arrival_utc', DateTime, nullable=False),
        Column('airline_id', Integer, nullable=False),
        Column('from_id', BigInteger, nullable=False),
        Column('to_id', BigInteger, nullable=False),
        Column('number', Text, nullable=False),
        Column('last_update', DateTime, nullable=False),
    )
    op.create_unique_constraint(
        'flight_uniq_constraint',
        'flight',
        ['departure', 'arrival', 'departure_utc', 'arrival_utc', 'airline_id', 'from_id', 'to_id', 'number'],
    )
    pass


def downgrade():
    op.drop_table('flight')
    op.execute(DropSequence(FLIGHT_ID_SEQ))
