"""partial

Revision ID: 53b063131ac1
Revises: cedb70b8cb1d
Create Date: 2017-09-27 22:11:32.102032+00:00

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = '53b063131ac1'
down_revision = 'cedb70b8cb1d'
branch_labels = None
depends_on = None


def upgrade():
    for i in range(100):
        table_name = 'z_variant_{:02d}'.format(i)
        op.execute('CREATE TABLE {} () INHERITS (variant)'.format(table_name))
        op.create_unique_constraint(
            '{}_uniq_constraint'.format(table_name), table_name, ['fare_id', 'partner_id', 'vendor_id', 'has_baggage']
        )
    for i in range(100):
        table_name = 'z_fare_{:02d}'.format(i)
        op.execute('CREATE TABLE {} () INHERITS (fare)'.format(table_name))
        op.create_unique_constraint(
            '{}_uniq_constraint'.format(table_name),
            table_name,
            [
                'query_id',
                'forward_flight_1',
                'forward_flight_2',
                'forward_flight_3',
                'backward_flight_1',
                'backward_flight_2',
                'backward_flight_3',
            ],
        )


def downgrade():
    for i in range(100):
        op.execute('DROP TABLE IF EXISTS z_variant_{:02d}'.format(i))
    for i in range(100):
        op.execute('DROP TABLE z_fare_{:02d}'.format(i))
