"""fare

Revision ID: 670486503b7e
Revises: 4b1fcbcf469c
Create Date: 2017-09-27 13:22:18.906328+00:00

"""
from alembic import op
from sqlalchemy import Column, BigInteger, Sequence, ForeignKey, ARRAY, Integer, SmallInteger, Boolean, DateTime
from sqlalchemy.sql.ddl import CreateSequence, DropSequence

revision = '670486503b7e'
down_revision = '4b1fcbcf469c'
branch_labels = None
depends_on = None

FARE_ID_SEQ = Sequence('fare_id_seq')


def upgrade():
    op.execute(CreateSequence(FARE_ID_SEQ))
    op.create_table(
        'fare',
        Column('pk', BigInteger, FARE_ID_SEQ, primary_key=True, server_default=FARE_ID_SEQ.next_value()),
        Column('query_id', BigInteger, ForeignKey('query.pk')),
        Column('forward_flight_1', BigInteger, nullable=False),
        Column('forward_flight_2', BigInteger, nullable=False),
        Column('forward_flight_3', BigInteger, nullable=False),
        Column('backward_flight_1', BigInteger, nullable=False),
        Column('backward_flight_2', BigInteger, nullable=False),
        Column('backward_flight_3', BigInteger, nullable=False),
        Column('airlines', ARRAY(Integer), nullable=False),
        Column('forward_departure_airport', Integer),
        Column('forward_transfer_airports', ARRAY(Integer)),
        Column('forward_arrival_airport', Integer),
        Column('backward_departure_airport', Integer),
        Column('backward_transfer_airports', ARRAY(Integer)),
        Column('backward_arrival_airport', Integer),
        Column('forward_departure_time_type', SmallInteger, nullable=False),
        Column('forward_arrival_time_type', SmallInteger, nullable=False),
        Column('backward_departure_time_type', SmallInteger, nullable=False),
        Column('backward_arrival_time_type', SmallInteger, nullable=False),
        Column('count_transfer', SmallInteger, nullable=False),
        Column('duration_transfer', Integer),
        Column('has_airport_change', Boolean, nullable=False),
        Column('has_night_transfer', Boolean, nullable=False),
        Column('last_update', DateTime, nullable=False),
    )
    op.create_unique_constraint(
        'fare_uniq_constraint',
        'fare',
        [
            'query_id',
            'forward_flight_1',
            'forward_flight_2',
            'forward_flight_3',
            'backward_flight_1',
            'backward_flight_2',
            'backward_flight_3',
        ],
    )


def downgrade():
    op.drop_table('fare')
    op.execute(DropSequence(FARE_ID_SEQ))
