"""variant

Revision ID: cedb70b8cb1d
Revises: 670486503b7e
Create Date: 2017-09-27 13:30:31.571334+00:00

"""
from alembic import op


from sqlalchemy import Column, BigInteger, ForeignKey, Integer, DateTime, Sequence, Boolean
from sqlalchemy.sql.ddl import CreateSequence, DropSequence

revision = 'cedb70b8cb1d'
down_revision = '670486503b7e'
branch_labels = None
depends_on = None

VARIANT_ID_SEQ = Sequence('variant_id_seq')


def upgrade():
    op.execute(CreateSequence(VARIANT_ID_SEQ))
    op.create_table(
        'variant',
        Column('pk', BigInteger, VARIANT_ID_SEQ, primary_key=True, server_default=VARIANT_ID_SEQ.next_value()),
        Column('fare_id', BigInteger, ForeignKey('fare.pk')),
        Column('partner_id', Integer, nullable=False),
        Column('vendor_id', Integer, nullable=False),
        Column('has_baggage', Boolean, nullable=False),
        Column('value', Integer, nullable=False),
        Column('currency_id', Integer, nullable=False),
        Column('baggage_weight', Integer, nullable=True),
        Column('baggage_pieces', Integer, nullable=True),
        Column('last_update', DateTime, nullable=False),
    )

    op.create_unique_constraint(
        'variant_uniq_constraint', 'variant', ['fare_id', 'partner_id', 'vendor_id', 'has_baggage']
    )


def downgrade():
    op.drop_table('variant')
    op.execute(DropSequence(VARIANT_ID_SEQ))
