"""add primary key for partial table

Revision ID: 2735f7b46c33
Revises: 53b063131ac1
Create Date: 2017-10-19 20:18:01.751725+00:00

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = '2735f7b46c33'
down_revision = '53b063131ac1'
branch_labels = None
depends_on = None


def upgrade():
    op.execute('COMMIT')
    for partial_name in ['variant', 'fare']:
        for i in range(100):
            try:
                table_name = 'z_{}_{:02d}'.format(partial_name, i)
                primary_name = '{}_primary_key'.format(table_name)
                index_name = '{}_uniq_pk_index'.format(table_name)

                print('start create primary key constraint {}'.format(index_name))

                op.execute("CREATE UNIQUE INDEX CONCURRENTLY {} ON {} (pk);".format(index_name, table_name))

                op.execute(
                    "ALTER TABLE {} ADD CONSTRAINT {} PRIMARY KEY USING INDEX {};".format(
                        table_name, primary_name, index_name
                    )
                )

                print('finish create primary key constraint {}'.format(index_name))
            except Exception as e:
                print(e, partial_name, i)


def downgrade():
    for partial_name in ['variant', 'fare']:
        for i in range(100):
            table_name = 'z_{}_{:02d}'.format(partial_name, i)
            index_name = '{}_primary_key'.format(table_name)

            print('start create index {}'.format(index_name))

            op.execute("ALTER TABLE {} DROP CONSTRAINT {};".format(table_name, index_name))

            print('finish create index {}'.format(index_name))
