"""add new fields

Revision ID: c7b599a688a2
Revises: e1a01e14a07d
Create Date: 2017-10-26 10:33:24.731481+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'c7b599a688a2'
down_revision = 'e1a01e14a07d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('plane_variant', sa.Column('base_value', sa.Integer(), nullable=False))
    op.add_column('plane_variant', sa.Column('ttl', sa.SmallInteger(), nullable=False))
    op.drop_index('plane_variant_price_index', table_name='plane_variant')
    op.create_index(
        'plane_variant_price_index',
        'plane_variant',
        ['national_version_id', 'from_id', 'to_id', 'forward_date', 'backward_date', 'has_baggage', 'base_value'],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('plane_variant_price_index', table_name='plane_variant')
    op.create_index(
        'plane_variant_price_index',
        'plane_variant',
        ['national_version_id', 'from_id', 'to_id', 'forward_date', 'backward_date', 'has_baggage', 'value'],
    )
    op.drop_column('plane_variant', 'ttl')
    op.drop_column('plane_variant', 'base_value')
    # ### end Alembic commands ###
