"""add the plane variant model

Revision ID: e1a01e14a07d
Revises: 2735f7b46c33
Create Date: 2017-10-26 04:16:53.348481+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'e1a01e14a07d'
down_revision = '2735f7b46c33'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'plane_variant',
        sa.Column('national_version_id', sa.SmallInteger(), nullable=False),
        sa.Column('from_id', sa.Integer(), nullable=False),
        sa.Column('to_id', sa.Integer(), nullable=False),
        sa.Column('forward_date', sa.Date(), nullable=False),
        sa.Column('backward_date', sa.Date(), nullable=False),
        sa.Column('forward_flight_1', sa.BigInteger(), nullable=False),
        sa.Column('forward_flight_2', sa.BigInteger(), nullable=False),
        sa.Column('forward_flight_3', sa.BigInteger(), nullable=False),
        sa.Column('backward_flight_1', sa.BigInteger(), nullable=False),
        sa.Column('backward_flight_2', sa.BigInteger(), nullable=False),
        sa.Column('backward_flight_3', sa.BigInteger(), nullable=False),
        sa.Column('has_baggage', sa.Boolean(), nullable=False),
        sa.Column('airlines', sa.ARRAY(sa.Integer()), nullable=False),
        sa.Column('forward_departure_airport', sa.Integer(), nullable=True),
        sa.Column('forward_transfer_airports', sa.ARRAY(sa.Integer()), nullable=True),
        sa.Column('forward_arrival_airport', sa.Integer(), nullable=True),
        sa.Column('backward_departure_airport', sa.Integer(), nullable=True),
        sa.Column('backward_transfer_airports', sa.ARRAY(sa.Integer()), nullable=True),
        sa.Column('backward_arrival_airport', sa.Integer(), nullable=True),
        sa.Column('forward_departure_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('forward_arrival_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('backward_departure_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('backward_arrival_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('count_transfer', sa.SmallInteger(), nullable=False),
        sa.Column('duration_transfer', sa.Integer(), nullable=True),
        sa.Column('has_airport_change', sa.Boolean(), nullable=False),
        sa.Column('has_night_transfer', sa.Boolean(), nullable=False),
        sa.Column('value', sa.Integer(), nullable=False),
        sa.Column('currency_id', sa.Integer(), nullable=False),
        sa.Column('last_update', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint(
            'national_version_id',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            'forward_flight_1',
            'forward_flight_2',
            'forward_flight_3',
            'backward_flight_1',
            'backward_flight_2',
            'backward_flight_3',
            'has_baggage',
            name='plane_variant_pk_constraint',
        ),
    )
    op.create_index(
        'plane_variant_price_index',
        'plane_variant',
        ['national_version_id', 'from_id', 'to_id', 'forward_date', 'backward_date', 'has_baggage', 'value'],
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('plane_variant_price_index')
    op.drop_table('plane_variant')
    # ### end Alembic commands ###
