"""add create_at

Revision ID: 2261e785ae26
Revises: 94691943abbc
Create Date: 2017-12-11 07:15:41.647556+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '2261e785ae26'
down_revision = '94691943abbc'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('flight', sa.Column('created_at', sa.DateTime(), nullable=True))
    op.alter_column('flight', 'last_update', existing_type=postgresql.TIMESTAMP(), nullable=True)
    op.add_column('plane_variant', sa.Column('created_at', sa.DateTime(), nullable=True))
    op.alter_column('plane_variant', 'expire', existing_type=postgresql.TIMESTAMP(), nullable=True)


def downgrade():
    op.alter_column('plane_variant', 'expire', existing_type=postgresql.TIMESTAMP(), nullable=False)
    op.drop_column('plane_variant', 'created_at')

    op.alter_column('flight', 'last_update', existing_type=postgresql.TIMESTAMP(), nullable=False)
    op.drop_column('flight', 'created_at')
