"""add direction price table

Revision ID: 1450f48aa399
Revises: 2261e785ae26
Create Date: 2017-12-17 19:23:40.837519+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '1450f48aa399'
down_revision = '2261e785ae26'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'direction_price',
        sa.Column('national_version_id', sa.SmallInteger(), nullable=False),
        sa.Column('from_id', sa.Integer(), nullable=False),
        sa.Column('to_id', sa.Integer(), nullable=False),
        sa.Column('forward_date', sa.Date(), nullable=False),
        sa.Column('backward_date', sa.Date(), nullable=False),
        sa.Column('base_value', sa.Integer(), nullable=False),
        sa.Column('value', sa.Integer(), nullable=False),
        sa.Column('currency_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint(
            'national_version_id',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            name='direction_price_pk_constraint',
        ),
    )
    op.create_index(
        'direction_price_index',
        'direction_price',
        ['national_version_id', 'from_id', 'to_id', 'forward_date', 'backward_date', 'base_value'],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('direction_price_index', table_name='direction_price')
    op.drop_table('direction_price')
    # ### end Alembic commands ###
