"""add dynamic row table

Revision ID: ed229be0affe
Revises: b8b54be9e15f
Create Date: 2018-01-19 14:18:54.724863+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'ed229be0affe'
down_revision = 'b8b54be9e15f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'dynamic_row',
        sa.Column('pk', sa.BigInteger(), nullable=False),
        sa.Column('national_version_id', sa.SmallInteger(), nullable=False),
        sa.Column('from_id', sa.Integer(), nullable=False),
        sa.Column('to_id', sa.Integer(), nullable=False),
        sa.Column('forward_date', sa.Date(), nullable=False),
        sa.Column('backward_date', sa.Date(), nullable=False),
        sa.Column('has_baggage', sa.Boolean(), nullable=False),
        sa.Column('airlines', sa.ARRAY(sa.Integer()), nullable=False),
        sa.Column('forward_departure_airport', sa.Integer(), nullable=True),
        sa.Column('forward_transfer_airports', sa.ARRAY(sa.Integer()), nullable=True),
        sa.Column('forward_arrival_airport', sa.Integer(), nullable=True),
        sa.Column('backward_departure_airport', sa.Integer(), nullable=True),
        sa.Column('backward_transfer_airports', sa.ARRAY(sa.Integer()), nullable=True),
        sa.Column('backward_arrival_airport', sa.Integer(), nullable=True),
        sa.Column('forward_departure_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('forward_arrival_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('backward_departure_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('backward_arrival_time_type', sa.SmallInteger(), nullable=False),
        sa.Column('count_transfer', sa.SmallInteger(), nullable=False),
        sa.Column('duration_transfer', sa.Integer(), nullable=True),
        sa.Column('has_airport_change', sa.Boolean(), nullable=False),
        sa.Column('has_night_transfer', sa.Boolean(), nullable=False),
        sa.Column('base_value', sa.Integer(), nullable=False),
        sa.Column('value', sa.Integer(), nullable=False),
        sa.Column('currency_id', sa.Integer(), nullable=False),
        sa.Column('expire', sa.DateTime(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('pk'),
        sa.UniqueConstraint(
            'national_version_id',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            'has_baggage',
            name='dynamic_row_uniq_constraint',
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('dynamic_row')
    # ### end Alembic commands ###
