"""experiment

Revision ID: 2221661bebad
Revises: f54eae609812
Create Date: 2018-04-19 20:37:48.261634+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '2221661bebad'
down_revision = 'f54eae609812'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'result',
        sa.Column('pk', sa.BigInteger(), nullable=False),
        sa.Column('national_version_id', sa.SmallInteger(), nullable=False),
        sa.Column('from_id', sa.Integer(), nullable=False),
        sa.Column('to_id', sa.Integer(), nullable=False),
        sa.Column('adults_count', sa.SmallInteger(), nullable=False),
        sa.Column('children_count', sa.SmallInteger(), nullable=False),
        sa.Column('infants_count', sa.SmallInteger(), nullable=False),
        sa.Column('forward_date', sa.Date(), nullable=False),
        sa.Column('backward_date', sa.Date(), nullable=False),
        sa.Column('base_value', sa.Integer(), nullable=False),
        sa.Column('value', sa.Integer(), nullable=False),
        sa.Column('currency_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=False),
        sa.Column('updated_at', sa.DateTime(), nullable=False),
        sa.Column('data', sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint('pk'),
    )
    op.create_index(
        'result_index',
        'result',
        [
            'national_version_id',
            'adults_count',
            'children_count',
            'infants_count',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
        ],
        unique=True,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('result_index', table_name='result')
    op.drop_table('result')
    # ### end Alembic commands ###
