from sqlalchemy.ext.declarative import declarative_base

# noinspection PyProtectedMember
from sqlalchemy.ext.declarative.base import _as_declarative, _add_attribute


# noinspection SpellCheckingInspection,PyInitNewSignature
class DeclarativeMeta(type):
    def __init__(cls, class_name, bases, dict_):
        if 'new_class_name' in dict_:
            class_name = dict_['new_class_name']
        if '_decl_class_registry' not in cls.__dict__:
            _as_declarative(cls, class_name, cls.__dict__)
        type.__init__(cls, class_name, bases, dict_)

    def __setattr__(cls, key, value):
        _add_attribute(cls, key, value)


DbModel = declarative_base(metaclass=DeclarativeMeta)
