from sqlalchemy import Date, DateTime, SmallInteger, PrimaryKeyConstraint, Index
from sqlalchemy import Column, Integer

from travel.avia.price_index.db_models.base_model import DbModel

PRIMARY_CONSTRAINT = PrimaryKeyConstraint(
    'national_version_id', 'from_id', 'to_id', 'forward_date', 'backward_date', name='direction_price_pk_constraint'
)


class DirectionPrice(DbModel):
    __tablename__ = 'direction_price'

    national_version_id = Column(SmallInteger, nullable=False)
    from_id = Column(Integer, nullable=False)
    to_id = Column(Integer, nullable=False)
    adults_count = Column(SmallInteger, nullable=False, default=1)
    children_count = Column(SmallInteger, nullable=False, default=0)
    infants_count = Column(SmallInteger, nullable=False, default=0)
    forward_date = Column(Date, nullable=False)
    backward_date = Column(Date, nullable=False)
    base_value = Column(Integer, nullable=False)
    value = Column(Integer, nullable=False)
    currency_id = Column(Integer, nullable=False)
    created_at = Column(DateTime, nullable=False)

    __table_args__ = (
        PRIMARY_CONSTRAINT,
        Index(
            'direction_base_value_index',
            'national_version_id',
            'adults_count',
            'children_count',
            'infants_count',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            'base_value',
        ),
    )

    def __repr__(self):
        return (
            "<DirectionPrice national_version_id={} from_id={} to_id={} "
            "forward_date={} backward_date={}] "
            "price=[{}/{}/{}]>".format(
                self.national_version_id,
                self.from_id,
                self.to_id,
                self.forward_date,
                self.backward_date,
                self.base_value,
                self.value,
                self.currency_id,
            )
        )
