from sqlalchemy import Boolean, Date, DateTime, SmallInteger, BigInteger, ARRAY, Index
from sqlalchemy import Column, Integer

from travel.avia.price_index.db_models.base_model import DbModel


class DynamicRow(DbModel):
    __tablename__ = 'dynamic_row'

    pk = Column(BigInteger, primary_key=True, autoincrement=True)
    national_version_id = Column(SmallInteger, nullable=False)
    from_id = Column(Integer, nullable=False)
    to_id = Column(Integer, nullable=False)
    adults_count = Column(SmallInteger, nullable=False, default=1)
    children_count = Column(SmallInteger, nullable=False, default=0)
    infants_count = Column(SmallInteger, nullable=False, default=0)
    forward_date = Column(Date, nullable=False)
    backward_date = Column(Date, nullable=False)
    has_baggage = Column(Boolean, nullable=False)
    airlines = Column(ARRAY(Integer), nullable=False)
    forward_departure_airport = Column(Integer)
    forward_transfer_airports = Column(ARRAY(Integer))
    forward_arrival_airport = Column(Integer)
    backward_departure_airport = Column(Integer)
    backward_transfer_airports = Column(ARRAY(Integer))
    backward_arrival_airport = Column(Integer)
    forward_departure_time_type = Column(SmallInteger, nullable=False)
    forward_arrival_time_type = Column(SmallInteger, nullable=False)
    backward_departure_time_type = Column(SmallInteger, nullable=False)
    backward_arrival_time_type = Column(SmallInteger, nullable=False)
    count_transfer = Column(SmallInteger, nullable=False)
    duration_transfer = Column(Integer)
    has_airport_change = Column(Boolean, nullable=False)
    has_night_transfer = Column(Boolean, nullable=False)
    base_value = Column(Integer, nullable=False)
    value = Column(Integer, nullable=False)
    currency_id = Column(Integer, nullable=False)
    expire = Column(DateTime, nullable=True)
    created_at = Column(DateTime, nullable=True)

    __table_args__ = (
        Index(
            'dynamic_row_base_value_index',
            'national_version_id',
            'adults_count',
            'children_count',
            'infants_count',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            'base_value',
        ),
    )

    def __repr__(self):
        return (
            "<DynamicRow national_version_id={} from_id={} to_id={} "
            "forward_date={} backward_date={} "
            "price=[{}/{}/{}]>".format(
                self.national_version_id,
                self.from_id,
                self.to_id,
                self.forward_date,
                self.backward_date,
                self.base_value,
                self.value,
                self.currency_id,
            )
        )
