from sqlalchemy import Date, DateTime, SmallInteger, PrimaryKeyConstraint, Index, Boolean
from sqlalchemy import Column, Integer

from travel.avia.price_index.db_models.base_model import DbModel

PRIMARY_CONSTRAINT = PrimaryKeyConstraint(
    'national_version_id', 'from_id', 'to_id', 'forward_date', 'backward_date', name='history_pk_constraint'
)


class History(DbModel):
    __tablename__ = 'history'

    national_version_id = Column(SmallInteger, nullable=False)
    from_id = Column(Integer, nullable=False)
    to_id = Column(Integer, nullable=False)
    adults_count = Column(SmallInteger, nullable=False, default=1)
    children_count = Column(SmallInteger, nullable=False, default=0)
    infants_count = Column(SmallInteger, nullable=False, default=0)
    forward_date = Column(Date, nullable=False)
    backward_date = Column(Date, nullable=False)
    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)
    has_variants = Column(Boolean, nullable=False)

    __table_args__ = (
        PRIMARY_CONSTRAINT,
        Index(
            'history_forward_date_index',
            'forward_date',
        ),
        Index(
            'history_updated_at_index',
            'updated_at',
        ),
    )

    def __repr__(self):
        return (
            "<History national_version_id={} from_id={} to_id={} "
            "forward_date={} backward_date={} "
            "created_at={} updated_at={}/>".format(
                self.national_version_id,
                self.from_id,
                self.to_id,
                self.forward_date,
                self.backward_date,
                self.created_at,
                self.updated_at,
            )
        )
