from sqlalchemy import (
    Date,
    DateTime,
    SmallInteger,
    BigInteger,
    JSON,
    UniqueConstraint,
)
from sqlalchemy import Column, Integer
from sqlalchemy.dialects.postgresql import BYTEA

from travel.avia.price_index.db_models.base_model import DbModel


class Result(DbModel):
    __tablename__ = 'result'

    pk = Column(BigInteger, primary_key=True, autoincrement=True)
    national_version_id = Column(SmallInteger, nullable=False)
    from_id = Column(Integer, nullable=False)
    to_id = Column(Integer, nullable=False)
    adults_count = Column(SmallInteger, nullable=False, default=1)
    children_count = Column(SmallInteger, nullable=False, default=0)
    infants_count = Column(SmallInteger, nullable=False, default=0)
    forward_date = Column(Date, nullable=False)
    backward_date = Column(Date, nullable=False)
    base_value = Column(Integer, nullable=False)
    value = Column(Integer, nullable=False)
    currency_id = Column(Integer, nullable=False)
    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)
    data = Column(JSON, nullable=True)
    gzip_data = Column(BYTEA, nullable=True)

    __table_args__ = (
        UniqueConstraint(
            'national_version_id',
            'adults_count',
            'children_count',
            'infants_count',
            'from_id',
            'to_id',
            'forward_date',
            'backward_date',
            name='result_unique',
        ),
    )

    def __repr__(self):
        return (
            "<Result national_version_id={} from_id={} to_id={} "
            "forward_date={} backward_date={} "
            "adults_count={} children_count={} infants_count={}]>".format(
                self.national_version_id,
                self.from_id,
                self.to_id,
                self.forward_date,
                self.backward_date,
                self.adults_count,
                self.children_count,
                self.infants_count,
            )
        )
