# coding: utf8
from base_util import nginx_log_normalize_uri

paths = [
    (r'search_methods/v1/next_days_min_prices/', '/search_methods/v1/next_days_min_prices/'),
    (r'search_methods/v1/top_directions_by_date_window/', '/search_methods/v1/top_directions_by_date_window/'),
    (r'search_methods/v1/min_price_batch_search/', '/search_methods/v1/min_price_batch_search/'),
    (r'search_methods/v1/dump/', '/search_methods/v1/dump/'),
    (
        r'search_methods/v1/search/[a-z]+/\d{4}\-\d{2}\-\d{2}/\d{4}\-\d{2}\-\d{2}/\d{4}\-\d{2}\-\d{2}/\d+/',
        '/search_methods/v1/search/ONE-WAY',
    ),
    (
        r'search_methods/v1/search/[a-z]+/\d{4}\-\d{2}\-\d{2}/\d{4}\-\d{2}\-\d{2}/\d{4}\-\d{2}\-\d{2}/\d{4}\-\d{2}\-\d{2}/\d+/',
        '/search_methods/v1/search/TWO-WAY',
    ),
]


def nginx_log_normalize_path(uri):
    return nginx_log_normalize_uri(paths, uri)
