# coding=utf-8
import os
import logging

from travel.avia.library.python.shared_objects import SharedFlag

from travel.avia.price_index.lib.currency_provider import currency_provider
from travel.avia.price_index.lib.logging_configurator import setup_logs
from travel.avia.price_index.lib.national_version_provider import national_version_provider
from travel.avia.price_index.lib.rates_provider import rates_provider
from travel.avia.price_index.lib.settings import settings


max_requests = int(os.getenv('GUNICORN_MAX_REQUESTS', 10000))

preload_app = True
reload = True

bind = os.getenv('AVIA_PRICE_INDEX_BIND', 'unix:/var/run/avia-price-index.sock')
workers = int(os.getenv('AVIA_PRICE_INDEX_WORKERS', 2))
errorlog = settings.LOG_ROOT + '/gunicorn.log'

if not os.getenv('YA_TEST_RUNNER'):
    setup_logs()
logger = logging.getLogger('gunicorn')

VERSION = os.getenv('DEPLOY_DOCKER_IMAGE', ':unknown').rsplit(':', 1)[-1]
TRACING_SERVICE_NAME = 'avia-price-index'
TRACING_JAEGER_SAMPLER_TIPE = os.getenv('JAEGER_SAMPLER_TYPE', 'probabilistic')
TRACING_JAEGER_SAMPLER_PARAMETER = float(os.getenv('JAEGER_SAMPLER_PARAMETER', 0.001))


def precache(server):
    national_version_provider.fetch()
    rates_provider.fetch()
    currency_provider.fetch()


def on_starting(server):
    logger.info('start!')
    precache(server)


def on_reload(server):
    logger.info('reload!')
    precache(server)


def pre_fork(server, worker):
    pass


shutdown_flag = SharedFlag()


def post_fork(server, worker):
    from flask_opentracing_helpers import setup_tracing

    from travel.avia.price_index.app import application

    application.shutdown_flag = shutdown_flag

    logger.info('Setup tracing...')

    env_variables = ['DEPLOY_STAGE_ID', 'DEPLOY_NODE_DC', 'DEPLOY_BOX_ID']

    try:
        setup_tracing(
            flask_application=application,
            service_name=TRACING_SERVICE_NAME,
            version=VERSION,
            include_env_variables=env_variables,
            filter_paths=['ping'],
            jaeger_sampler_type=TRACING_JAEGER_SAMPLER_TIPE,
            jaeger_sampler_parameter=TRACING_JAEGER_SAMPLER_PARAMETER,
        )
    except Exception:
        logger.exception('Failed to setup tracing')
    else:
        logger.info('Done setup tracing successfully')
