# -*- coding: utf-8 -*-


from datetime import date, timedelta


class AdjustedDateWindow(object):
    def __init__(self, day, window_size):
        # type: (date, int) -> None
        self.day = day
        self.window_size = window_size
        self._calculate_boundaries()

    def __repr__(self):
        return "<AdjustedDateWindow d={} window_size={}>".format(self.day, self.window_size)

    def _calculate_boundaries(self):
        self.left_boundary = max(date.today(), self.day - timedelta(days=self.window_size))
        self.right_boundary = self.left_boundary + timedelta(days=self.window_size * 2)
