from typing import Optional

from travel.avia.price_index.lib.currency_provider import CurrencyProvider, currency_provider
from travel.avia.price_index.lib.rates_provider import RatesProvider, rates_provider


class BaseCurrencyProvider(object):
    def __init__(self, currency_provider, rates_provider):
        # type: (CurrencyProvider, RatesProvider) -> None
        self._currency_provider = currency_provider
        self._rates_provider = rates_provider

    def get_code(self, national_version_id):
        # type: (int) -> Optional[unicode]
        currency_id = self._rates_provider.get_base_currency_id(nv_id=national_version_id)
        model = self._currency_provider.get_by_id(currency_id, national_version_id)

        if model is None:
            return None

        return model.code


base_currency_provider = BaseCurrencyProvider(currency_provider=currency_provider, rates_provider=rates_provider)
