from datetime import timedelta, date

from typing import Generator, Tuple, Optional

from travel.avia.price_index.models.daterange import DateRange
from travel.avia.price_index.models.query import Query


class DateRangeIterator(object):
    def iterate(self, query, date_range):
        # type: (Query, DateRange) -> Generator[Tuple[date, Optional[date]]]
        start = date_range.start
        delta = 0

        if query.backward_date:
            delta = (query.backward_date - query.forward_date).days
        while start <= date_range.end:
            forward_date = start
            backward_date = None
            if query.backward_date:
                backward_date = start + timedelta(days=delta)

            yield forward_date, backward_date

            start += timedelta(days=1)


date_range_iterator = DateRangeIterator()
