from contextlib import contextmanager


@contextmanager
def session_scope(storage):
    """Provide a transactional scope around a series of operations."""
    session = storage.get_session()
    try:
        yield session
        session.commit()
    except:
        session.rollback()
        raise
    finally:
        session.close()
