from sqlalchemy.interfaces import ConnectionProxy


class TimeOutProxy(ConnectionProxy):
    def __init__(self, timeout):
        super(TimeOutProxy, self).__init__()
        self.timeout = timeout

    def cursor_execute(self, execute, cursor, statement, parameters, context, executemany):
        cursor.execute('SET statement_timeout TO %d;' % int(int(self.timeout) * 1000))
        return execute(cursor, statement, parameters, context)
