from logging import Logger

from flask import g


class FlaskLogger(Logger):
    def _get_session_id(self):
        try:
            return g.session_id
        except Exception:
            return None

    def makeRecord(self, name, level, fn, lno, msg, args, exc_info, func=None, extra=None, sinfo=None):
        session_id = self._get_session_id()

        if msg and session_id:
            msg = 'flask_session_id={} {}'.format(session_id, msg)
        return super().makeRecord(name, level, fn, lno, msg, args, exc_info, func, extra, sinfo)
