from typing import Tuple

from travel.avia.price_index.lib.indexer.index_builder.airlines_index_builder import (
    airline_index_builder,
    AirlineIndexBuilder,
)
from travel.avia.price_index.lib.indexer.index_builder.airport_index_builder import (
    airport_index_builder,
    AirportIndexBuilder,
)
from travel.avia.price_index.lib.indexer.index_builder.time_index_builder import (
    time_index_builder,
    TimeIndexBuilder,
)
from travel.avia.price_index.lib.indexer.index_builder.transfer_index_builder import (
    transfer_index_builder,
    TransferIndexBuilder,
)
from travel.avia.price_index.models.flight import Flight
from travel.avia.price_index.models.index_data import FareIndex


class FareIndexBuilder(object):
    def __init__(self, airport_index_builder, time_index_builder, transfer_index_builder, airline_index_builder):
        # type: (AirportIndexBuilder, TimeIndexBuilder, TransferIndexBuilder, AirlineIndexBuilder) -> None
        self._airport_index_builder = airport_index_builder
        self._time_index_builder = time_index_builder
        self._transfer_index_builder = transfer_index_builder
        self._airline_index_builder = airline_index_builder

    def index(self, forward_flights, backward_flights):
        # type: (Tuple[Flight, ...], Tuple[Flight, ...]) -> FareIndex

        return FareIndex(
            transfer_index=self._transfer_index_builder.index(forward_flights, backward_flights),
            time_index=self._time_index_builder.index(forward_flights, backward_flights),
            airport_index=self._airport_index_builder.index(forward_flights, backward_flights),
            airlines_index=self._airline_index_builder.index(forward_flights, backward_flights),
        )


fare_index_builder = FareIndexBuilder(
    airport_index_builder=airport_index_builder,
    time_index_builder=time_index_builder,
    transfer_index_builder=transfer_index_builder,
    airline_index_builder=airline_index_builder,
)
