from typing import Set, Tuple

from travel.avia.price_index.models.flight import Flight


class AirlineIndexBuilder(object):
    def index(self, forward_flights, backward_flights):
        # type: (Tuple[Flight, ...], Tuple[Flight, ...]) -> Set[int]
        return {flight.airline_id for flight in forward_flights + backward_flights if flight.airline_id is not None}


airline_index_builder = AirlineIndexBuilder()
