from typing import Tuple

from travel.avia.price_index.models.flight import Flight
from travel.avia.price_index.models.index_data import AirportIndex, AirportIndexByDirection


class AirportIndexBuilder(object):
    def index(self, forward_flights, backward_flights):
        # type: (Tuple[Flight, ...], Tuple[Flight, ...]) -> AirportIndex

        return AirportIndex(
            forward=self._index(forward_flights),
            backward=self._index(backward_flights),
        )

    def _index(self, flights):
        if not flights:
            return AirportIndexByDirection(arrival=None, transfer=set(), departure=None)

        departure = flights[0].from_id
        arrival = flights[-1].to_id
        transfers = set()
        if len(flights) > 1:
            transfers.add(flights[0].to_id)
            transfers.add(flights[-1].from_id)
            for f in flights[1:-1]:
                transfers.add(f.from_id)
                transfers.add(f.to_id)

        return AirportIndexByDirection(
            departure=departure,
            transfer=transfers,
            arrival=arrival,
        )


airport_index_builder = AirportIndexBuilder()
