from typing import Tuple

from travel.avia.price_index.models.flight import Flight
from travel.avia.price_index.models.index_data import TimeIndex


class TimeIndexBuilder(object):
    def index(self, forward_flights, backward_flights):
        # type:(Tuple[Flight, ...], Tuple[Flight, ...]) -> TimeIndex
        forward_departure = forward_flights[0].departure
        forward_arrival = forward_flights[-1].arrival

        backward_departure = None
        backward_arrival = None
        if len(backward_flights):
            backward_departure = backward_flights[0].departure
            backward_arrival = backward_flights[-1].arrival

        return TimeIndex(
            forward_departure=self._get_time_type(forward_departure),
            forward_arrival=self._get_time_type(forward_arrival),
            backward_departure=self._get_time_type(backward_departure),
            backward_arrival=self._get_time_type(backward_arrival),
        )

    def _get_time_type(self, timestamp):
        if not timestamp:
            return TimeIndex.UNKNOWN

        time = (timestamp.hour, timestamp.minute)

        if (0, 0) <= time < (6, 0):
            return TimeIndex.NIGHT
        if (6, 0) <= time < (12, 0):
            return TimeIndex.MORNING
        if (12, 0) <= time < (18, 0):
            return TimeIndex.DAY
        if (18, 0) <= time < (24, 0):
            return TimeIndex.EVENING
        return TimeIndex.UNKNOWN


time_index_builder = TimeIndexBuilder()
