from sqlalchemy.dialects.postgresql import insert


def _get_dict_from_model(model, columns):
    return {column: getattr(model, column) for column in columns}


def _get_dicts_from_model(models):
    some_model = models[0]
    columns = [c.name for c in some_model.__table__.columns if c.name != 'pk']

    return [_get_dict_from_model(m, columns) for m in models]


def insert_or_nothing(session, model_klass, models, constraint):
    if not len(models):
        return

    values = _get_dicts_from_model(models)

    stmt = insert(model_klass, inline=True, values=values)

    session.connection().execute(stmt.on_conflict_do_nothing(constraint=constraint.name))
    session.flush()
