from typing import Optional

from travel.avia.price_index.models.query import Query


class PassengersMultiplier(object):
    def multiply(self, value: int, adults: int, children: int, infants: int) -> int:
        return int(value * (adults + children + infants * 0))

    def normalize(self, raw_base_value, requested_query, query):
        # type: (int, Query, Query) -> Optional[int]
        if raw_base_value is None:
            return raw_base_value

        requested_is_single = requested_query.is_single()
        query_is_single = query.is_single()
        if self._is_equal_query_by_passenger(query, requested_query):
            return raw_base_value

        if requested_is_single and not query_is_single:
            return self.multiply(
                value=raw_base_value,
                adults=query.adults_count,
                children=query.children_count,
                infants=query.infants_count,
            )

        raise RuntimeError('Unexpected input')

    def _is_equal_query_by_passenger(self, some, other):
        # type: (Query, Query) -> bool
        return (
            some.adults_count == other.adults_count
            and some.children_count == other.children_count
            and some.infants_count == other.infants_count
        )


passengers_multiplier = PassengersMultiplier()
