from logging import getLogger, Logger
from typing import Dict, Optional


class PriceConverter(object):
    def __init__(self, logger):
        # type: (Logger) -> None
        self._logger = logger

    def convert_to_base_currency_id(self, price, currency_id, base_currency_id, rate_by_currency_id):
        # type: (int, int, int, Dict[int, float]) -> Optional[int]
        if not base_currency_id:
            return None

        if currency_id == base_currency_id:
            return price

        rate = rate_by_currency_id.get(currency_id)

        if not rate:
            self._logger.warn('can not find rate for %r', currency_id)
            return None

        return int(price * rate)


price_converter = PriceConverter(logger=getLogger(__name__))
