# -*- coding: utf-8 -*-


from typing import Tuple, Dict

from sqlalchemy.orm import Session

from travel.avia.price_index.lib.query_searcher.filter_query_searcher import (
    FilterQuerySearcher,
    searcher as filter_searcher,
)
from travel.avia.price_index.lib.query_searcher.min_query_searcher import MinQuerySearcher, searcher as min_searcher
from travel.avia.price_index.models.filters import Filters
from travel.avia.price_index.models.query import Query


class QuerySearcher(object):
    def __init__(self, filter_searcher, min_searcher):
        # type: (FilterQuerySearcher, MinQuerySearcher) -> None

        self._filter_searcher = filter_searcher
        self._min_searcher = min_searcher

    def batch_find(self, session, queries, filters):
        # type: (Session, Tuple[Query, ...], Filters) -> Dict[Query, int]

        if filters.is_empty():
            return self._min_searcher.batch_find(session, queries)
        return self._filter_searcher.batch_find(session, queries, filters)


query_searcher = QuerySearcher(filter_searcher=filter_searcher, min_searcher=min_searcher)
