# -*- coding: utf-8 -*-


from sqlalchemy import and_
from sqlalchemy.sql.expression import delete as _delete

from travel.avia.price_index.db_models.result import Result
from travel.avia.price_index.lib.constants import NULL_DATE


class DeleteResultOperation(object):
    def save(self, session, result_model):
        table = Result.__table__

        backward_date = result_model.backward_date or NULL_DATE
        stmt = _delete(table).where(
            and_(
                table.c.national_version_id == result_model.national_version_id,
                table.c.from_id == result_model.from_id,
                table.c.to_id == result_model.to_id,
                table.c.adults_count == result_model.adults_count,
                table.c.children_count == result_model.children_count,
                table.c.infants_count == result_model.infants_count,
                table.c.forward_date == result_model.forward_date,
                table.c.backward_date == backward_date,
            )
        )
        session.execute(stmt)
        session.flush()


delete = DeleteResultOperation()
