# -*- coding: utf-8 -*-


from sqlalchemy.dialects.postgresql import insert

from travel.avia.price_index.db_models.result import Result
from travel.avia.price_index.lib.constants import NULL_DATE


class OnConflictResultOperation(object):
    def save(self, session, result_model):
        table = Result.__table__

        stmt = (
            insert(table)
            .values(
                national_version_id=result_model.national_version_id,
                from_id=result_model.from_id,
                to_id=result_model.to_id,
                adults_count=result_model.adults_count,
                children_count=result_model.children_count,
                infants_count=result_model.infants_count,
                forward_date=result_model.forward_date,
                backward_date=result_model.backward_date or NULL_DATE,
                base_value=result_model.base_value,
                value=result_model.value,
                currency_id=result_model.currency_id,
                created_at=result_model.created_at,
                updated_at=result_model.updated_at,
                gzip_data=result_model.gzip_data,
            )
            .on_conflict_do_update(
                constraint='result_unique',
                set_=dict(
                    base_value=result_model.base_value,
                    value=result_model.value,
                    currency_id=result_model.currency_id,
                    created_at=result_model.created_at,
                    updated_at=result_model.updated_at,
                    data=None,
                    gzip_data=result_model.gzip_data,
                ),
            )
        )
        session.execute(stmt)
        session.flush()


on_conflict = OnConflictResultOperation()
