# -*- coding: utf-8 -*-


from travel.avia.price_index.db_models.result import Result
from travel.avia.price_index.lib.constants import NULL_DATE


class UpdateExistingResultOperation(object):
    def save(self, session, result_model):
        r = Result(
            national_version_id=result_model.national_version_id,
            from_id=result_model.from_id,
            to_id=result_model.to_id,
            adults_count=result_model.adults_count,
            children_count=result_model.children_count,
            infants_count=result_model.infants_count,
            forward_date=result_model.forward_date,
            backward_date=result_model.backward_date or NULL_DATE,
            base_value=result_model.base_value,
            value=result_model.value,
            currency_id=result_model.currency_id,
            created_at=result_model.created_at,
            updated_at=result_model.updated_at,
            gzip_data=result_model.gzip_data,
        )

        exists = bool(
            session.query(Result)
            .filter(
                Result.national_version_id == r.national_version_id,
                Result.from_id == r.from_id,
                Result.to_id == r.to_id,
                Result.adults_count == r.adults_count,
                Result.children_count == r.children_count,
                Result.infants_count == r.infants_count,
                Result.forward_date == r.forward_date,
                Result.backward_date == r.backward_date,
            )
            .count()
        )

        if not exists:
            session.add(r)
        else:
            session.query(Result).filter(
                Result.national_version_id == r.national_version_id,
                Result.from_id == r.from_id,
                Result.to_id == r.to_id,
                Result.adults_count == r.adults_count,
                Result.children_count == r.children_count,
                Result.infants_count == r.infants_count,
                Result.forward_date == r.forward_date,
                Result.backward_date == r.backward_date,
            ).update(
                {
                    'base_value': r.base_value,
                    'value': r.value,
                    'currency_id': r.currency_id,
                    'created_at': r.created_at,
                    'updated_at': r.updated_at,
                    'gzip_data': r.gzip_data,
                },
                synchronize_session=False,
            )
        session.flush()


update_existing = UpdateExistingResultOperation()
