import os

from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info import MdbAPI, POSTGRES_API_BASE_URL


class Settings(object):
    def __init__(self):
        pgaas_cluster_id = self.get_env_or_die('PGAAS_CLUSTER_ID')
        pgaas_database_name = self.get_env_or_die('PGAAS_DATABASE_NAME')
        pgaas_user_for_work = self.get_env_or_die('PGAAS_USER_FOR_WORK')
        pgaas_password_for_work = self.get_env_or_die('PGAAS_PASSWORD_FOR_WORK')
        pgaas_user_for_migration = self.get_env_or_die('PGAAS_USER_FOR_MIGRATION')
        pgaas_password_for_migration = self.get_env_or_die('PGAAS_PASSWORD_FOR_MIGRATION')
        pgaas_port = self.get_env_or_die('PGAAS_PORT', default=6432)
        self.PGAAS_STATEMENT_TIMEOUT = int(self.get_env_or_die('PGAAS_STATEMENT_TIMEOUT', default=25))

        mdb_api = MdbAPI(
            api_base_url=POSTGRES_API_BASE_URL,
            oauth_token=self.get_env_or_die('MDB_API_TOKEN'),
        )
        mdb_api.add_default_cluster_info(
            cluster_id=pgaas_cluster_id,
            master_hostname='c-{}.rw.db.yandex.net'.format(pgaas_cluster_id),
            hostnames=['c-{}.ro.db.yandex.net'.format(pgaas_cluster_id)],
        )
        cluster_info = mdb_api.get_cluster_info(pgaas_cluster_id)
        cluster_info.sort_replicas_by_dc(os.environ.get('CURRENT_DC'))

        self.MASTER_CONNECTION_STRING_FOR_WORK = cluster_info.psycopg2_connection_string(
            user=pgaas_user_for_work,
            password=pgaas_password_for_work,
            database=pgaas_database_name,
            port=pgaas_port,
            sslmode='require',
            target_session_attrs='read-write',
        )

        self.MASTER_CONNECTION_STRING_FOR_MIGRATION = cluster_info.psycopg2_connection_string(
            user=pgaas_user_for_migration,
            password=pgaas_password_for_migration,
            database=pgaas_database_name,
            port=pgaas_port,
            sslmode='require',
            target_session_attrs='read-write',
        )

        self.SLAVE_CONNECTION_STRING = cluster_info.psycopg2_connection_string(
            user=pgaas_user_for_work,
            password=pgaas_password_for_work,
            database=pgaas_database_name,
            port=pgaas_port,
            sslmode='require',
            target_session_attrs='any',
        )

        self.TEST_CONNECTION_STRING = self.get_env_or_die('TEST_CONNECTION_STRING')
        self.BACKEND_HOST = self.get_env_or_die('BACKEND_HOST')
        self.LOG_ROOT = self.get_env_or_die('LOG_ROOT', default='')
        self.DEBUG = bool(self.get_env_or_die('DEBUG', default=False))
        self.ENABLE_LOG_SQL_QUERIES = self.get_env_or_die('ENABLE_LOG_SQL_QUERIES') == 'true'

        self.SELF_TVM_ID = self.get_env_or_die('TVM_ID', default=0)
        self.SELF_TVM_TOKEN = os.getenv('TVMTOOL_LOCAL_AUTHTOKEN', self.get_env_or_die('TVM_SECRET'))
        self.FAKE_TVM = self.get_env_or_die('FAKE_TVM') == 'true'

        self.FEATURE_FLAG_HOST = self.get_env_or_die('FEATURE_FLAG_HOST')

        self.YT_TOKEN = os.environ.get('YT_TOKEN')

    @staticmethod
    def get_env_or_die(name, default=None):
        env_name = 'AVIA_PRICE_INDEX_{}'.format(name)

        return os.environ.get(env_name, default)


os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'
settings = Settings()
