from travel.library.python.tvm_ticket_provider import provider_fabric

from travel.avia.price_index.lib.settings import settings


class TvmVerifier(object):
    def __init__(self, tvm_id, tvm_token):
        self._tvm_id = tvm_id
        self._tvm_token = tvm_token
        self._client = None

    def _get_client(self):
        if not self._client:
            self._client = provider_fabric.create(
                source_id=self._tvm_id,
                secret=self._tvm_token,
            )

        return self._client

    def get_source_by_ticket(self, service_ticket):
        if service_ticket is None:
            return None
        return self._get_client().check_service_ticket(service_ticket).src


tvm_verifier = TvmVerifier(settings.SELF_TVM_ID, settings.SELF_TVM_TOKEN)
