from typing import Optional
from datetime import date


class DirectionRequest(object):
    def __init__(self, orig_id, dest_id, forward_date, backward_date):
        # type: (int, int, date, Optional[date]) -> None
        self.orig_id = orig_id
        self.dest_id = dest_id
        self.forward_date = forward_date
        self.backward_date = backward_date

    def __repr__(self):
        return '<DirectionRequest orig_id={} dest_id={}> ' 'forward_date={} backward_date={}'.format(
            self.orig_id, self.dest_id, self.forward_date, self.backward_date
        )
