from typing import List, Optional


class Filters(object):
    def __init__(self, with_baggage, airlines, transfer_filters, time_filters, airports_filters):
        # type: (bool, List[int], TransferFilter, TimeFilter, AirportsFilter) -> None
        self.with_baggage = with_baggage
        self.airlines = airlines
        self.transfer_filters = transfer_filters
        self.time_filters = time_filters
        self.airports_filters = airports_filters

    def is_empty(self):
        return (
            self.with_baggage is None
            and len(self.airlines) == 0
            and self.transfer_filters.is_empty()
            and self.time_filters.is_empty()
            and self.airports_filters.is_empty()
        )

    def __repr__(self):
        return '<Filters with_baggage={} airlines={} transfer={} ' 'time_filters={} airports_filters={}>'.format(
            self.with_baggage, self.airlines, self.transfer_filters, self.time_filters, self.airports_filters
        )


class TransferFilter(object):
    def __init__(self, count, min_duration, max_duration, has_airport_change, has_night):
        # type: (Optional[int], Optional[int], Optional[int], bool, bool) -> None
        self.count = count
        self.min_duration = min_duration
        self.max_duration = max_duration
        self.has_airport_change = has_airport_change
        self.has_night = has_night

    def is_empty(self):
        return (
            self.count is None
            and self.min_duration is None
            and self.max_duration is None
            and self.has_airport_change is None
            and self.has_night is None
        )

    def __repr__(self):
        return '<TransferFilter count={} min_duration={} max_duration={} has_airport_change={} has_night={}>'.format(
            self.count, self.min_duration, self.max_duration, self.has_airport_change, self.has_night
        )


class TimeFilter(object):
    def __init__(self, forward_arrival, forward_departure, backward_arrival, backward_departure):
        # type: (Optional[int], Optional[int], Optional[int], Optional[int]) -> None
        self.forward_arrival = forward_arrival
        self.forward_departure = forward_departure
        self.backward_arrival = backward_arrival
        self.backward_departure = backward_departure

    def is_empty(self):
        return (
            self.forward_arrival is None
            and self.forward_departure is None
            and self.backward_arrival is None
            and self.backward_departure is None
        )

    def __repr__(self):
        return (
            '<TimeFilter forward_arrival={} forward_departure={} '
            'backward_arrival={} backward_departure={}>'.format(
                self.forward_arrival, self.forward_departure, self.backward_arrival, self.backward_departure
            )
        )


class AirportsFilter(object):
    def __init__(
        self,
        forward_departure,
        forward_arrival,
        forward_transfers,
        backward_departure,
        backward_arrival,
        backward_transfers,
    ):
        # type: (List[int], List[int], List[int], List[int], List[int], List[int]) -> None
        self.forward_departure = forward_departure
        self.forward_arrival = forward_arrival
        self.forward_transfers = forward_transfers
        self.backward_departure = backward_departure
        self.backward_arrival = backward_arrival
        self.backward_transfers = backward_transfers

    def is_empty(self):
        return (
            len(self.forward_departure) == 0
            and len(self.forward_arrival) == 0
            and len(self.forward_transfers) == 0
            and len(self.backward_departure) == 0
            and len(self.backward_arrival) == 0
            and len(self.backward_transfers) == 0
        )

    def __repr__(self):
        return (
            '<AirportsFilter forward_departure={} forward_arrival={} '
            'forward_transfers={} backward_departure={} '
            'backward_arrival={} backward_transfers={}>'.format(
                self.forward_departure,
                self.forward_arrival,
                self.forward_transfers,
                self.backward_departure,
                self.backward_arrival,
                self.backward_transfers,
            )
        )
