from typing import Set, Optional


class TimeIndex(object):
    UNKNOWN = 0
    MORNING = 1
    DAY = 2
    EVENING = 3
    NIGHT = 4

    def __init__(self, forward_arrival, forward_departure, backward_arrival, backward_departure):
        # type: (int, int, int, int) -> None
        self.forward_arrival = forward_arrival
        self.forward_departure = forward_departure
        self.backward_arrival = backward_arrival
        self.backward_departure = backward_departure


class AirportIndexByDirection(object):
    def __init__(self, arrival, transfer, departure):
        # type: (Optional[int], Set[int], Optional[int]) -> None
        self.arrival = arrival
        self.transfer = transfer
        self.departure = departure


class AirportIndex(object):
    def __init__(self, forward, backward):
        # type: (AirportIndexByDirection, AirportIndexByDirection) -> None
        self.forward = forward
        self.backward = backward


class TransferIndex(object):
    def __init__(self, count, duration, has_airport_change, has_night_transfer):
        # type: (int, int, bool, bool) -> None
        self.count = count
        self.duration = duration
        self.has_airport_change = has_airport_change
        self.has_night_transfer = has_night_transfer


class FareIndex(object):
    def __init__(self, transfer_index, time_index, airport_index, airlines_index):
        # type: (TransferIndex, TimeIndex, AirportIndex, Set[int]) -> None

        self.transfer_index = transfer_index
        self.time_index = time_index
        self.airport_index = airport_index
        self.airline_index = airlines_index
