# -*- coding: utf-8 -*-


from datetime import date

from typing import Optional


class Query(object):
    def __init__(
        self,
        national_version_id,
        from_id,
        to_id,
        forward_date,
        backward_date,
        adults_count,
        children_count,
        infants_count,
    ):
        # type: (int, int, int, date, Optional[date], int, int, int) -> None
        self.national_version_id = national_version_id
        self.from_id = from_id
        self.to_id = to_id
        self.forward_date = forward_date
        self.backward_date = backward_date
        self.adults_count = adults_count
        self.children_count = children_count
        self.infants_count = infants_count

    def is_single(self):
        # type: () -> bool
        return self.adults_count == 1 and self.children_count == 0 and self.infants_count == 0

    def __repr__(self):
        return "<Query national_version_id={} route={}-{} dates={}-{} passengers={},{},{}/>".format(
            self.national_version_id,
            self.from_id,
            self.to_id,
            self.forward_date,
            self.backward_date,
            self.adults_count,
            self.children_count,
            self.infants_count,
        )

    def __hash__(self):
        return (
            hash(self.national_version_id)
            + hash(self.from_id)
            + hash(self.to_id)
            + hash(self.forward_date)
            + hash(self.backward_date)
            + hash(self.adults_count)
            + hash(self.children_count)
            + hash(self.infants_count)
        )

    def __eq__(self, o):
        if not isinstance(o, Query):
            return False

        return (
            self.national_version_id == o.national_version_id
            and self.from_id == o.from_id
            and self.to_id == o.to_id
            and self.forward_date == o.forward_date
            and self.backward_date == o.backward_date
            and self.adults_count == o.adults_count
            and self.children_count == o.children_count
            and self.infants_count == o.infants_count
        )


class IndexQuery(Query):
    def __init__(
        self,
        national_version_id,
        from_id,
        to_id,
        forward_date,
        backward_date,
        adults_count,
        children_count,
        infants_count,
        raw_data,
    ):
        # type: (int, int, int, date, Optional[date], int, int, int, dict) -> None
        super(IndexQuery, self).__init__(
            national_version_id,
            from_id,
            to_id,
            forward_date,
            backward_date,
            adults_count,
            children_count,
            infants_count,
        )
        self.raw_data = raw_data
