from typing import Optional, List
from datetime import date


class Direction(object):
    def __init__(self, orig_id, dest_id):
        # type: (int,int) -> None
        self.orig_id = orig_id
        self.dest_id = dest_id


class TopDirectionsByDateWindowRequest(object):
    def __init__(self, directions, forward_date, backward_date, window_size, results_per_direction):
        # type: (List[Direction], date, Optional[date], int, int) -> None
        self.directions = directions
        self.forward_date = forward_date
        self.backward_date = backward_date
        self.window_size = window_size
        self.results_per_direction = results_per_direction

    def __repr__(self):
        return (
            '<TopDirectionsByDateWindowRequest directions={} '
            'forward_date={} backward_date={} window_size={} '
            'results_per_direction={}'.format(
                self.directions, self.forward_date, self.backward_date, self.window_size, self.results_per_direction
            )
        )
