# -*- coding: utf-8 -*-


from marshmallow import Schema, fields, post_load, EXCLUDE

from travel.avia.price_index.models.dump_form import DumpForm


class DumpFormSchema(Schema):
    class Meta:
        unknown = EXCLUDE

    adults_count = fields.Integer(required=False, missing=1, default=1)
    children_count = fields.Integer(required=False, missing=0, default=0)
    infants_count = fields.Integer(required=False, missing=0, default=0)

    from_id = fields.Integer(required=False, missing=None)
    to_id = fields.Integer(required=False, missing=None)
    delta = fields.Integer(required=False, missing=60)

    @post_load
    def make_query(self, data, *args, **kwargs):
        return DumpForm(**data)
