from marshmallow import Schema, fields, post_load, EXCLUDE

from travel.avia.price_index.models.daterange import DateRange


class RangeSchema(Schema):
    class Meta:
        unknown = EXCLUDE

    start = fields.Date(required=True)
    end = fields.Date(required=True)

    @post_load
    def make_range(self, data, *args, **kwargs):
        return DateRange(**data)
